#!/bin/sh

DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_OK=0
DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ERROR=1
DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_CODE=${DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ERROR}

DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ROLLING=0
DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_MSG=""

dply_page_sc_dhcp_or_static() {
	debug_print "${0}" "${LINENO}" 'in function "dply_page_sc_dhcp_or_static"'
	
    # assign default value
    [ -z "${RT_SC_IP}" ]      && RT_SC_IP="${conf_sc_ip}"
    [ -z "${RT_SC_NETMASK}" ] && RT_SC_NETMASK="${conf_sc_netmask}"
    [ -z "${RT_SC_DNS}" ]     && RT_SC_DNS="${conf_sc_dns}"
    [ -z "${RT_SC_GATEWAY}" ] && RT_SC_GATEWAY="${conf_sc_gateway}"
    
	tp_dhcp_or_static \
		"${DPLY_PAGE_SC_DHCP_OR_STATIC_TITLE}" \
		"${DPLY_PAGE_SC_DHCP_OR_STATIC_TEXT}" \
		"${DPLY_PAGE_SC_DHCP_OR_STATIC_LABEL_OK}" \
		"${DPLY_PAGE_SC_DHCP_OR_STATIC_LABEL_CANCEL}"


	debug_print "${0}" "${LINENO}" "TP_DHCP_OR_STATIC_RESULT_CODE: ${TP_DHCP_OR_STATIC_RESULT_CODE}"
    case "${TP_DHCP_OR_STATIC_RESULT_CODE}" in
    
        "${TP_DHCP_OR_STATIC_RESULT_ERROR}")
            DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_CODE=$DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ERROR
            DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_MSG=""
            DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ROLLING=0
            return
            ;;
        
        "${TP_DHCP_OR_STATIC_RESULT_CANCEL}")
            DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_CODE=$DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_OK
            DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_MSG=""
            DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ROLLING=-1
            return
            ;;
            
        "${TP_DHCP_OR_STATIC_RESULT_OK}" )
            ;;
        
        *)
            DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_CODE=$DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ERROR
            DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_MSG="${DPLY_PAGE_SC_DHCP_OR_STATIC_ERROR_UNKNOWN}"
            DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ROLLING=0
            return
            ;;
    esac
   
   
	case "${TP_DHCP_OR_STATIC_RESULT_SELECT}" in
	
		# user choose "use static ip"
		"${TP_DHCP_OR_STATIC_RESULT_STATIC}")
			RT_SC_DHCP=0
			
			DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_CODE=$DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_OK
			DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ROLLING=1
			DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_MSG=""
			;;
		
		# user choose "use DHCP"
		"${TP_DHCP_OR_STATIC_RESULT_DHCP}")
			RT_SC_DHCP=1
			
			# apply and error handling
			utility_apply_sc_network_conf "${RT_SC_DHCP}" "" "" "" ""
			if [ "${?}" -ne 0 ]; then
				DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_CODE=$DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ERROR
				DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ROLLING=0
				DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_MSG="${DPLY_PAGE_SC_DHCP_OR_STATIC_ERROR_APPLY_NETWORK_CONF}: ${UTILITY_APPLY_SC_NETWORK_CONF_RESULT_MSG}"
				return
			fi

            # save to database
            RT_SC_IP="${UTILITY_APPLY_SC_NETWORK_CONF_RESULT_IP}"
            RT_SC_NETMASK="${UTILITY_APPLY_SC_NETWORK_CONF_RESULT_NETMASK}"
            RT_SC_DNS="${UTILITY_APPLY_SC_NETWORK_CONF_RESULT_DNS}"
            RT_SC_GATEWAY="${UTILITY_APPLY_SC_NETWORK_CONF_RESULT_GATEWAY}"
            utility_save_sc_network_conf \
                "${RT_SC_DHCP}" \
                "${RT_SC_IP}" \
                "${RT_SC_NETMASK}" \
                "${RT_SC_GATEWAY}" \
                "${RT_SC_DNS}"
            if [ "${?}" -ne 0 ]; then
				DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_CODE=$DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ERROR
				DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ROLLING=0
				DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_MSG="${DPLY_PAGE_SC_DHCP_OR_STATIC_ERROR_SAVE_CONFIGURATION}: ${UTILITY_SAVE_SC_NETWORK_CONF_RESULT_MSG}"
				return
            fi
                
			DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_CODE=$DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_OK
			DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ROLLING=2
			DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_MSG=""
			;;
		
		*)
			DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_CODE=$DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ERROR
			DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_MSG="${DPLY_PAGE_SC_DHCP_OR_STATIC_ERROR_APPLY_NETWORK_CONF}: ${STRING_UNKNOWN_ERROR}"
			DPLY_PAGE_SC_DHCP_OR_STATIC_RESULT_ROLLING=0
			;;
	esac
}